/*
 * Decompiled with CFR 0.152.
 */
package com.boot.lwjgl3;

import boot.DualGameHost;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Application;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Files;
import com.boot.lwjgl3.StartupHelper;
import game1.beatdz.Binary;
import game1.com.tgame.model.Caption;

public class Lwjgl3Launcher {
    private static final int DEFAULT_WIDTH = 960;
    private static final int DEFAULT_HEIGHT = 640;

    public static void main(String[] args) {
        if (StartupHelper.startNewJvmIfRequired()) {
            return;
        }
        Lwjgl3Launcher.bootstrapFileHandles();
        System.out.println("Local storage path: " + Gdx.files.getLocalStoragePath());
        Caption.loadVN();
        Lwjgl3Launcher.createApplication();
    }

    private static void bootstrapFileHandles() {
        if (Gdx.files == null) {
            Gdx.files = new Lwjgl3Files();
        }
    }

    private static Lwjgl3Application createApplication() {
        int[] size = Lwjgl3Launcher.resolveWindowSize();
        return new Lwjgl3Application(new DualGameHost(), Lwjgl3Launcher.getDefaultConfiguration(size[0], size[1]));
    }

    private static int[] resolveWindowSize() {
        try {
            short[] dims = Binary.b();
            if (dims != null && dims.length >= 2) {
                int width = Math.max(640, dims[0]);
                int height = Math.max(480, dims[1]);
                return new int[]{width, height};
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new int[]{960, 640};
    }

    private static Lwjgl3ApplicationConfiguration getDefaultConfiguration(int width, int height) {
        Lwjgl3ApplicationConfiguration configuration = new Lwjgl3ApplicationConfiguration();
        configuration.setTitle("Lang La Plus");
        configuration.useVsync(true);
        configuration.setForegroundFPS(Lwjgl3ApplicationConfiguration.getDisplayMode().refreshRate + 1);
        configuration.setWindowedMode(width, height);
        configuration.setResizable(false);
        configuration.setWindowIcon("resource/4.png", "resource/5.png", "resource/6.png");
        return configuration;
    }
}

