/*
 * Decompiled with CFR 0.152.
 */
package boot;

import boot.TabSwitchBridge;
import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.TimeUtils;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import game2.beatdz.DataCenter;
import game3.beatdz.AppListener;

public class DualGameHost
extends ApplicationAdapter {
    private static final int TAB_COUNT = 3;
    private static final long BG_TICK_INTERVAL_MS = 300L;
    private final EmbeddedGame[] games = new EmbeddedGame[3];
    private int activeIndex;
    private SpriteBatch batch;
    private OrthographicCamera camera;
    private Stage overlayStage;
    private TextButton switchButton;
    private TextButton[] tabButtons;
    private boolean tabMenuVisible;
    private InputMultiplexer inputMultiplexer;
    private InputProcessor activeInput;
    private BitmapFont tabFont;
    private Texture bgTex;

    public DualGameHost() {
        this.games[0] = new EmbeddedGame(new game1.beatdz.AppListener(), "Tab 1", 0);
        this.games[1] = new EmbeddedGame(new game2.beatdz.AppListener(), "Tab 2", 1);
        this.games[2] = new EmbeddedGame(new AppListener(), "Tab 3", 2);
    }

    @Override
    public void create() {
        this.batch = new SpriteBatch();
        this.camera = new OrthographicCamera();
        this.overlayStage = new Stage(new ScreenViewport(), this.batch);
        FreeTypeFontGenerator gen = new FreeTypeFontGenerator(Gdx.files.internal("resource/font1.ttf"));
        FreeTypeFontGenerator.FreeTypeFontParameter param = new FreeTypeFontGenerator.FreeTypeFontParameter();
        param.size = 20;
        param.borderWidth = 1.4f;
        param.borderColor = Color.BLACK;
        param.color = Color.WHITE;
        this.tabFont = gen.generateFont(param);
        gen.dispose();
        TextButton.TextButtonStyle style = new TextButton.TextButtonStyle();
        style.font = this.tabFont;
        Pixmap px = new Pixmap(1, 1, Pixmap.Format.RGBA8888);
        px.setColor(0.0f, 0.0f, 0.0f, 0.6f);
        px.fill();
        this.bgTex = new Texture(px);
        px.dispose();
        TextureRegionDrawable bg = new TextureRegionDrawable(new TextureRegion(this.bgTex));
        style.up = bg;
        style.over = bg;
        style.down = bg.tint(new Color(0.8f, 0.8f, 0.8f, 0.9f));
        this.switchButton = new TextButton("TAB 1", style);
        this.switchButton.getLabel().setFontScale(1.87f);
        this.layoutSwitchButton();
        this.switchButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                DualGameHost.this.toggleTabMenu();
            }
        });
        this.overlayStage.addActor(this.switchButton);
        this.tabButtons = new TextButton[3];
        for (int i = 0; i < 3; ++i) {
            final int tabIndex = i;
            String label = i == 0 ? "TAB 1" : (i == 1 ? "TAB 2" : "TAB 3");
            TextButton b = new TextButton(label, style);
            b.getLabel().setFontScale(1.33f);
            b.setVisible(false);
            b.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    DualGameHost.this.setActiveIndex(tabIndex);
                    DualGameHost.this.hideTabMenu();
                }
            });
            this.tabButtons[i] = b;
            this.overlayStage.addActor(b);
        }
        this.tabMenuVisible = false;
        TabSwitchBridge.setHandler(this::handleToggleRequest);
        this.activeIndex = 0;
        int width = Gdx.graphics.getWidth();
        int height = Gdx.graphics.getHeight();
        this.games[0].initIfNeeded(width, height);
        this.updateInputProcessor();
        this.announceActiveTab();
    }

    @Override
    public void resize(int width, int height) {
        if (this.overlayStage != null) {
            this.overlayStage.getViewport().update(width, height, true);
            this.layoutSwitchButton();
        }
        for (EmbeddedGame game : this.games) {
            if (!game.initialized) continue;
            game.disposeFrameBuffer();
            game.listener.resize(width, height);
        }
    }

    @Override
    public void render() {
        this.ensureInputProcessorConsistency();
        int width = Gdx.graphics.getWidth();
        int height = Gdx.graphics.getHeight();
        EmbeddedGame activeGame = this.games[this.activeIndex];
        if (activeGame.initialized) {
            activeGame.ensureBuffer(width, height);
            activeGame.frameBuffer.begin();
            Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            Gdx.gl.glClear(16384);
            InputProcessor inputProcessor = Gdx.input.getInputProcessor();
            activeGame.listener.render();
            InputProcessor after = Gdx.input.getInputProcessor();
            if (after != inputProcessor) {
                activeGame.inputProcessor = after;
                this.activeInput = after;
            }
            activeGame.frameBuffer.end();
            this.restoreActiveInput();
        }
        for (EmbeddedGame g : this.games) {
            if (g.index == this.activeIndex || !g.initialized) continue;
            g.backgroundTick(width, height);
        }
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.camera.setToOrtho(false, width, height);
        this.batch.setProjectionMatrix(this.camera.combined);
        this.batch.begin();
        TextureRegion textureRegion = this.games[this.activeIndex].region;
        if (textureRegion != null) {
            this.batch.draw(textureRegion, 0.0f, 0.0f, (float)width, (float)height);
        }
        this.batch.end();
        this.overlayStage.act(Gdx.graphics.getDeltaTime());
        this.overlayStage.draw();
    }

    @Override
    public void pause() {
        for (EmbeddedGame game : this.games) {
            game.listener.pause();
        }
    }

    @Override
    public void resume() {
        for (EmbeddedGame game : this.games) {
            game.listener.resume();
        }
    }

    @Override
    public void dispose() {
        TabSwitchBridge.setHandler(null);
        for (EmbeddedGame game : this.games) {
            game.dispose();
        }
        if (this.batch != null) {
            this.batch.dispose();
        }
        if (this.overlayStage != null) {
            this.overlayStage.dispose();
        }
        if (this.tabFont != null) {
            this.tabFont.dispose();
        }
        if (this.bgTex != null) {
            this.bgTex.dispose();
        }
    }

    private void toggleActiveTab() {
        this.setActiveIndex((this.activeIndex + 1) % this.games.length);
    }

    private void setActiveIndex(int newIndex) {
        if (newIndex < 0 || newIndex >= this.games.length || newIndex == this.activeIndex) {
            return;
        }
        this.games[newIndex].initIfNeeded(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.activeIndex = newIndex;
        this.updateInputProcessor();
        this.updateButtonLabel();
        this.announceActiveTab();
    }

    private void updateInputProcessor() {
        this.activeInput = this.games[this.activeIndex].ensureInputProcessor();
        if (this.activeInput != null) {
            this.inputMultiplexer = new InputMultiplexer(this.overlayStage, this.activeInput);
            Gdx.input.setInputProcessor(this.inputMultiplexer);
        }
    }

    private void restoreActiveInput() {
        if (this.inputMultiplexer != null && Gdx.input.getInputProcessor() != this.inputMultiplexer) {
            Gdx.input.setInputProcessor(this.inputMultiplexer);
        }
    }

    private void ensureInputProcessorConsistency() {
        if (this.inputMultiplexer != null && Gdx.input.getInputProcessor() != this.inputMultiplexer) {
            Gdx.input.setInputProcessor(this.inputMultiplexer);
        }
    }

    private void handleToggleRequest(ApplicationListener source) {
        for (int i = 0; i < this.games.length; ++i) {
            if (this.games[i].listener != source) continue;
            this.setActiveIndex((i + 1) % this.games.length);
            return;
        }
    }

    private void announceActiveTab() {
        try {
            if (this.activeIndex == 0 && game1.beatdz.DataCenter.gI().currentScreen != null) {
                game1.beatdz.DataCenter.gI().currentScreen.showMessage("\u0110ang \u1edf TAB 1", -1);
            } else if (this.activeIndex == 1 && DataCenter.gI().currentScreen != null) {
                DataCenter.gI().currentScreen.showMessage("\u0110ang \u1edf TAB 2", -1);
            } else if (this.activeIndex == 2 && game3.beatdz.DataCenter.gI().currentScreen != null) {
                game3.beatdz.DataCenter.gI().currentScreen.showMessage("\u0110ang \u1edf TAB 3", -1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateButtonLabel() {
        if (this.switchButton != null) {
            String text = this.activeIndex == 0 ? "TAB 1" : (this.activeIndex == 1 ? "TAB 2" : "TAB 3");
            this.switchButton.setText(text);
            this.layoutSwitchButton();
        }
    }

    private void layoutSwitchButton() {
        if (this.switchButton == null) {
            return;
        }
        this.switchButton.pack();
        float textW = this.switchButton.getLabel().getPrefWidth();
        float textH = this.switchButton.getLabel().getPrefHeight();
        float padX = 40.0f;
        float padY = 20.0f;
        this.switchButton.setSize(textW + padX, textH + padY);
        this.switchButton.setPosition((float)Gdx.graphics.getWidth() - this.switchButton.getWidth() - 16.0f, (float)Gdx.graphics.getHeight() - this.switchButton.getHeight() - 16.0f);
        if (this.tabButtons != null) {
            float startX = this.switchButton.getX();
            float startY = this.switchButton.getY() - this.switchButton.getHeight() - 8.0f;
            for (int i = 0; i < 3; ++i) {
                TextButton b = this.tabButtons[i];
                if (b == null) continue;
                b.pack();
                float w = Math.max(b.getLabel().getPrefWidth() + padX, this.switchButton.getWidth());
                float h = this.switchButton.getHeight();
                b.setSize(w, h);
                b.setPosition(startX, startY - (float)i * (h + 4.0f));
            }
        }
    }

    private void toggleTabMenu() {
        if (this.tabMenuVisible) {
            this.hideTabMenu();
        } else {
            this.showTabMenu();
        }
    }

    private void showTabMenu() {
        this.tabMenuVisible = true;
        if (this.tabButtons != null) {
            for (TextButton b : this.tabButtons) {
                if (b == null) continue;
                b.setVisible(true);
            }
        }
    }

    private void hideTabMenu() {
        this.tabMenuVisible = false;
        if (this.tabButtons != null) {
            for (TextButton b : this.tabButtons) {
                if (b == null) continue;
                b.setVisible(false);
            }
        }
    }

    private static class EmbeddedGame {
        final ApplicationListener listener;
        final String label;
        final int index;
        FrameBuffer frameBuffer;
        TextureRegion region;
        InputProcessor inputProcessor;
        boolean initialized;
        long lastBgTick;

        EmbeddedGame(ApplicationListener listener, String label, int index) {
            this.listener = listener;
            this.label = label;
            this.index = index;
            this.initialized = false;
            this.lastBgTick = 0L;
        }

        void initIfNeeded(int width, int height) {
            if (this.initialized) {
                return;
            }
            this.listener.create();
            this.listener.resize(width, height);
            this.captureInputBinding();
            this.initialized = true;
        }

        void ensureBuffer(int width, int height) {
            if (this.frameBuffer != null && (this.frameBuffer.getWidth() != width || this.frameBuffer.getHeight() != height)) {
                this.disposeFrameBuffer();
            }
            if (this.frameBuffer == null) {
                this.frameBuffer = new FrameBuffer(Pixmap.Format.RGBA8888, width, height, false);
                this.region = new TextureRegion((Texture)this.frameBuffer.getColorBufferTexture());
                this.region.flip(false, true);
            }
        }

        void captureInputBinding() {
            InputProcessor processor = Gdx.input.getInputProcessor();
            if (processor != null) {
                this.inputProcessor = processor;
            }
        }

        InputProcessor ensureInputProcessor() {
            if (this.inputProcessor == null) {
                this.inputProcessor = new InputAdapter();
            }
            return this.inputProcessor;
        }

        void backgroundTick(int width, int height) {
            long now = TimeUtils.millis();
            if (now - this.lastBgTick < 300L) {
                return;
            }
            this.lastBgTick = now;
            this.ensureBuffer(width, height);
            this.frameBuffer.begin();
            Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            Gdx.gl.glClear(16384);
            InputProcessor before = Gdx.input.getInputProcessor();
            this.listener.render();
            if (Gdx.input.getInputProcessor() != before) {
                Gdx.input.setInputProcessor(before);
            }
            this.frameBuffer.end();
        }

        void disposeFrameBuffer() {
            if (this.frameBuffer != null) {
                this.frameBuffer.dispose();
                this.frameBuffer = null;
                this.region = null;
            }
        }

        void dispose() {
            this.listener.dispose();
            this.disposeFrameBuffer();
        }
    }
}

